<section class="home_div" id="home">
  <!-- User Info -->
  <div class="user-card">
    <img src="https://placehold.co/100" alt="User Logo" class="profile-pic" />
    <div class="user-info">
      <h3 class="UserName">UserName</h3>
      <p><strong>Balance:</strong> <span class="user-balance">$100</span></p>
    </div>
  </div>

  <!-- Earnings Section -->
  <div class="earnings-container">
    <div class="earn-card">
      <h5>Today's Earnings</h5>
      <span id="todayEarnings" class="lifetime_earning">$50</span>
    </div>
    <div class="earn-card">
      <h5>Lifetime Earnings</h5>
      <span id="lifetimeEarnings" class="lifetime_earning">$1000</span>
    </div>
  </div>

  <!-- Today's Tasks Section -->
  <div class="task-card">
    <h5>Today's Tasks</h5>
    <p><strong>Total Tasks:</strong> <span id="taskCount" class="taskCount">10</span></p>
    <p><strong>Completed:</strong> <span id="tasksCompleted" class="tasksCompleted">6</span></p>
    <p><strong>Remaining:</strong> <span id="tasksRemaining" class="tasksRemaining">4</span></p>
    <div class="progress mt-3">
      <div class="progress-bar bg-success" role="progressbar" style="width: 60%" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
        60% Completed
      </div>
    </div>
  </div>

  <!-- Social Page Link -->
  <div>
  </div>


  <div class="container mt-5">
  <h2 class="text-center">Join Our Community</h2>
  <div class="row text-center">
    <div class="col-md-4">
     
    <div class="col-md-4">
      <div class="card p-3">
        <img src="https://cdn-icons-png.flaticon.com/512/733/733585.png" width="50">
        <h5>WhatsApp</h5>
        <a href="{{ $links->whatsapp ?? '#' }}" class="btn btn-success" target="_blank">Join Now</a>
      </div>
    </div>
  </div>
</div>



  <style> 
  /* Global Styles */
/* Global Styles */
body {
  font-family: Arial, sans-serif;
  background-color: #f8f9fa;
}

.home_div {
  padding: 17px;
  display: flex;
  flex-direction: column;
  align-items: center;
}

/* User Card */
.user-card {
  position: relative;
  background: #ffffff;
  border-radius: 12px;
  padding: 20px;
  width: 100%;
  max-width: 100%;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  border-top: 4px solid #ff6b00; /* Dark Orange */
  display: flex;
  align-items: center;
  gap: 20px;
}

.user-card .profile-pic {
  width: 90px;
  height: 90px;
  border-radius: 50%;
  border: 4px solid white;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.user-card .user-info {
  text-align: left;
}

.user-card h3 {
  color: #ff6b00;
  margin: 0;
}

.user-card p {
  font-size: 16px;
  color: #333;
}

/* Earnings Section */
.earnings-container {
  display: flex;
  gap: 19px;
  margin-top: 20px;
  justify-content: center;
  flex-wrap: wrap;
}

.earn-card {
  width: 47%;
  padding: 13px;
  background: white;
  border-radius: 10px;
  text-align: center;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  border-top: 4px solid #ff6b00; /* Dark Orange */
}

.earn-card h5 {
  color: #ff6b00;
  margin-bottom: 10px;
}

.earn-card span {
  font-size: 18px;
  font-weight: bold;
  color: #333;
}

/* Tasks Section */
.task-card {
  border: 2px solid #ff6b00; /* Dark Orange */
  border-radius: 10px;
  padding: 20px;
  width: 100%;
  margin: 15px;
  text-align: center;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.task-card h5 {
  color: #ff6b00;
}

.progress {
  height: 10px;
  border-radius: 10px;
}

.progress-bar {
  border-radius: 10px;
}

/* Social Button */
.btn-primary {
  font-size: 16px;
  padding: 10px 20px;
  border-radius: 8px;
}





/* Container Styling */
.container {
  max-width: 100%;
  margin: auto;
}

/* Section Title */
h2.text-center {
  font-weight: bold;
  color: #333;
  margin-bottom: 30px;
}

/* Card Styling */
.card {
  border-radius: 10px;
  border: none;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
  text-align: center;
}

.card img {
  margin: auto;
  margin-bottom: 10px;
}

.card h5 {
  font-size: 18px;
  font-weight: bold;
  margin-bottom: 15px;
}

/* Button Styling */
.card a {
  font-size: 14px;
  font-weight: bold;
  padding: 8px 15px;
  border-radius: 5px;
  transition: background 0.3s, transform 0.2s;
}

/* Hover Effects */
.card:hover {
  transform: translateY(-5px);
  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
}

.card a:hover {
  transform: scale(1.05);
}

/* Responsive Design */
@media (max-width: 768px) {
  .row.text-center .col-md-4 {
    margin-bottom: 20px;
  }
}



   </style>
</section>
