<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Social Links Admin</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center">Update Social Links</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.update.links')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <label for="youtube" class="form-label">YouTube Link</label>
            <input type="text" name="youtube" class="form-control" value="<?php echo e($links->youtube ?? ''); ?>" required>
        </div>
        <div class="mb-3">
            <label for="telegram" class="form-label">Telegram Link</label>
            <input type="text" name="telegram" class="form-control" value="<?php echo e($links->telegram ?? ''); ?>" required>
        </div>
        <div class="mb-3">
            <label for="whatsapp" class="form-label">WhatsApp Link</label>
            <input type="text" name="whatsapp" class="form-control" value="<?php echo e($links->whatsapp ?? ''); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Update Links</button>
    </form>
</div>
</body>
</html>
<?php /**PATH E:\vAlphaBot\resources\views/admin/slink.blade.php ENDPATH**/ ?>